/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.scm.component.digital;

import com.mojang.math.Vector3f;
import com.technicalitiesmc.lib.circuit.component.CircuitComponent;
import com.technicalitiesmc.lib.circuit.component.CircuitEvent;
import com.technicalitiesmc.lib.circuit.component.ClientComponent;
import com.technicalitiesmc.lib.circuit.component.ComponentContext;
import com.technicalitiesmc.lib.circuit.component.ComponentEventMap;
import com.technicalitiesmc.lib.circuit.component.ComponentState;
import com.technicalitiesmc.lib.circuit.component.ComponentType;
import com.technicalitiesmc.lib.circuit.interfaces.RedstoneSink;
import com.technicalitiesmc.lib.circuit.interfaces.RedstoneSource;
import com.technicalitiesmc.lib.math.VecDirection;
import com.technicalitiesmc.lib.math.VecDirectionFlags;
import com.technicalitiesmc.lib.util.value.Reference;
import com.technicalitiesmc.scm.component.InterfaceLookup;
import com.technicalitiesmc.scm.component.digital.DigitalComponentBase;
import com.technicalitiesmc.scm.init.SCMComponents;
import com.technicalitiesmc.scm.init.SCMItems;
import com.technicalitiesmc.scm.menu.PulsarMenu;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class PulsarComponent
extends DigitalComponentBase<PulsarComponent> {
    private static final AABB BOUNDS = new AABB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0);
    private static final TranslatableComponent MENU_TITLE = new TranslatableComponent("container.supercircuitmaker.pulsar");
    private static final int DEFAULT_DELAY = 20;
    private static final Property<Boolean> PROP_ON = BooleanProperty.m_61465_((String)"on");
    private static final VecDirectionFlags OUTPUT_SIDES = VecDirectionFlags.horizontals();
    private static final InterfaceLookup<PulsarComponent> INTERFACES = InterfaceLookup.builder().with(RedstoneSource.class, OUTPUT_SIDES, PulsarComponent::getRedstoneSource).with(RedstoneSink.class, DigitalComponentBase.DEFAULT_INPUT_SIDES, RedstoneSink::instance).build();
    private boolean input;
    private int delay = 20;
    private int counter = 0;

    public PulsarComponent(ComponentContext context) {
        super(SCMComponents.PULSAR, context, INTERFACES);
    }

    private PulsarComponent(ComponentContext context, int delay, int counter) {
        this(context);
        this.delay = delay;
        this.counter = counter;
    }

    private void setDelay(int ticks) {
        this.updateExternalState(false, () -> {
            this.delay = ticks;
            this.counter = 0;
        });
    }

    public CircuitComponent copyRotated(ComponentContext context, Rotation rotation) {
        return new PulsarComponent(context, this.delay, this.counter);
    }

    public ComponentState getState() {
        return (ComponentState)super.getState().m_61124_(PROP_ON, (Comparable)Boolean.valueOf(this.counter == this.delay - 1));
    }

    public AABB getBoundingBox() {
        return BOUNDS;
    }

    public ItemStack getPickedItem() {
        return new ItemStack((ItemLike)SCMItems.PULSAR.get());
    }

    @Override
    public void onAdded() {
        super.onAdded();
        this.scheduleTick(1);
    }

    @Override
    protected boolean beforeCheckInputs(ComponentEventMap events, boolean tick) {
        if (tick) {
            int next = (this.counter + 1) % this.delay;
            boolean willBeOn = next == this.delay - 1;
            boolean notify = next == 0 || willBeOn;
            this.updateExternalState(true, () -> {
                this.counter = next;
            });
            if (notify) {
                this.sendEvent(CircuitEvent.REDSTONE, OUTPUT_SIDES);
            }
            if (!this.input || willBeOn) {
                this.scheduleTick(1);
            }
        }
        return true;
    }

    @Override
    protected void onNewInputs(boolean tick, byte newInputs) {
        if (this.getInputs() == 0 != (newInputs == 0)) {
            boolean bl = this.input = newInputs != 0;
            if (!this.input) {
                this.counter = 0;
                this.scheduleTick(1);
            }
        }
    }

    public InteractionResult use(Player player, InteractionHand hand, VecDirection sideHit, Vector3f hit) {
        player.m_5893_((MenuProvider)new SimpleMenuProvider((id, playerInv, $) -> new PulsarMenu(id, playerInv, p -> true, (Reference<Integer>)Reference.of(() -> this.delay, this::setDelay)), (Component)MENU_TITLE));
        return InteractionResult.m_19078_((boolean)false);
    }

    @Override
    public CompoundTag save(CompoundTag tag) {
        tag = super.save(tag);
        tag.m_128379_("input", this.input);
        tag.m_128405_("delay", this.delay);
        tag.m_128405_("counter", this.counter);
        return tag;
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        this.input = tag.m_128471_("input");
        this.delay = tag.m_128451_("delay");
        this.counter = tag.m_128451_("counter");
    }

    private RedstoneSource getRedstoneSource() {
        return this.counter == this.delay - 1 ? RedstoneSource.fullWeak() : RedstoneSource.off();
    }

    public static void createState(StateDefinition.Builder<ComponentType, ComponentState> builder) {
        builder.m_61104_(new Property[]{PROP_ON});
    }

    public static class Client
    extends ClientComponent {
        public AABB getBoundingBox(ComponentState state) {
            return BOUNDS;
        }

        public ItemStack getPickedItem(ComponentState state) {
            return new ItemStack((ItemLike)SCMItems.PULSAR.get());
        }

        public InteractionResult use(ComponentState state, Player player, InteractionHand hand, VecDirection sideHit, Vector3f hit) {
            return InteractionResult.m_19078_((boolean)true);
        }
    }
}

